#ifndef MERTECH_PRINT_SCALES_DRIVER_H
#define MERTECH_PRINT_SCALES_DRIVER_H


#include <iostream>
#include <vector>

#if defined(_WIN32) || defined(WIN32) || defined(_WIN64) || defined(WIN64)     \
  || defined(__WIN32__) || defined(__TOS_WIN__) || defined(__WINDOWS__)        \
  || defined(_WINDOWS) || defined(_WIN32_WINCE)
#  if defined(DTOX_LIBRARY)
#    define DTOX_SHARED_EXPORT __declspec(dllexport)
#  else
#    define DTOX_SHARED_EXPORT __declspec(dllimport)
#  endif
#  define DTOX_SHARED_CCA __cdecl
#elif defined(__linux) || defined(__linux__) || defined(linux)                 \
  || defined(ANDROID)
#  if __GNUC__ >= 4
#    define DTOX_SHARED_EXPORT __attribute__((visibility("default")))
#  else
#    define DTOX_SHARED_EXPORT
#  endif
#  define DTOX_SHARED_CCA
#elif defined(__APPLE__)
#  define DTOX_SHARED_EXPORT __attribute__((visibility("default")))
#  define DTOX_SHARED_CCA
#else
#  define DTOX_SHARED_EXPORT
#  define DTOX_SHARED_CCA __attribute__((cdecl))
#endif

#ifndef uchar
typedef unsigned char uchar;
#endif

#ifndef uint
typedef unsigned int uint;
#endif

#ifndef libfptrHDL
typedef void* libptr;
#endif


#ifdef __cplusplus
extern "C" {
#endif

	namespace nativedriver{
		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA create(libptr* handle);//libfptr_create
		DTOX_SHARED_EXPORT void DTOX_SHARED_CCA destroy(libptr* handle);

		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA set_int_param(libptr handle, int param_type, int64_t value);
		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA set_string_param(libptr handle, int param_type, std::string value);
		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA set_wstring_param(libptr handle, int param_type, std::wstring value);
		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA set_bytes_array_param(libptr handle, int param_type, std::vector<std::byte> value);
		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA get_int_param(libptr handle, int param_type, int64_t& value);
		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA get_string_param(libptr handle, int param_type, std::string& value);
		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA get_wstring_param(libptr handle, int param_type, std::wstring& value);
		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA get_bytes_array_param(libptr handle, int param_type, std::vector<std::byte>& value);

		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA execute_command(libptr handle, int command);
		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA change_locale(libptr handle, std::string value);

		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA get_input_int_param(libptr handle, int param_type, int64_t& value);
		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA get_input_string_param(libptr handle, int param_type, std::string& value);
		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA get_input_wstring_param(libptr handle, int param_type, std::wstring& value);
		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA get_input_bytes_array_param(libptr handle, int param_type, std::vector<std::byte>& value);




		//DTOX_SHARED_EXPORT int DTOX_SHARED_CCA set_string_param(libptr handle, int param_type, const char& value);
		//DTOX_SHARED_EXPORT int DTOX_SHARED_CCA get_string_param(libptr handle, int param_type, const char& value);
		//DTOX_SHARED_EXPORT int DTOX_SHARED_CCA get_input_string_param(libptr handle, int param_type, const char& value);

		//DTOX_SHARED_EXPORT int DTOX_SHARED_CCA set_wstring_param(libptr handle, int param_type, const wchar_t& value);
		//DTOX_SHARED_EXPORT int DTOX_SHARED_CCA get_wstring_param(libptr handle, int param_type, const wchar_t& value);
		//DTOX_SHARED_EXPORT int DTOX_SHARED_CCA get_input_wstring_param(libptr handle, int param_type, const wchar_t& value);

		//DTOX_SHARED_EXPORT int DTOX_SHARED_CCA set_bytes_array_param(libptr handle, int param_type, std::vector<std::byte> value);
		//DTOX_SHARED_EXPORT int DTOX_SHARED_CCA get_bytes_array_param(libptr handle, int param_type, std::vector<std::byte>& value);
		//DTOX_SHARED_EXPORT int DTOX_SHARED_CCA get_input_bytes_array_param(libptr handle, int param_type, std::vector<std::byte>& value);

		DTOX_SHARED_EXPORT int DTOX_SHARED_CCA change_locale(libptr handle, std::string value);

	}

#ifdef __cplusplus
}
#endif

#endif // MERTECH_PRINT_SCALES_DRIVER_H

